'******************************************************************************************************
'Jord, . (2009). Simultaneous Confidence Regions for Impulse Responses, 
'Review of Economics and Statistics, v. 91 (3), pp. 629647.
'******************************************************************************************************
'Load the file
import .\swqdata.csv names=(P,UN,FF) @freq q 1960Q1

'Estimate VAR with built-in procs
var swmodel.ls 1 14 p un ff

'Lag length selection with corrected AIC and dof unadjusted covariance matrix
swmodel.localirfs(imp=4,aicc)

'Comparison of Local IRFs with that of regular VAR (shows marginal error bands)
swmodel.localirfs(horizon=24,imp=4,compare,charts)

'Conditional error bands (saves the correlation matrix of IRFs)
swmodel.localirfs(horizon=24,imp=4,cond=2,cormat,charts)

'Scheffe error bands (50th percentile)
swmodel.localirfs(horizon=24,alpha=0.5,imp=4,cond=3,charts)

'Equality test of responses (UN to P versus FF to FF) and saves the resulting matrix
swmodel.localirfs(horizon=24,imp=4,equality="2 1 3 3",pval=2) 'p-values from F-test

'Counterfactual analysis of the response of FF to FF with conditioning the response path of P to FF
swmodel.localirfs(respmat="irf",horizon=24,imp=4) 'get the IRF matrix
vector condition = @columnextract(irf01,3) - 0.25*@ones(@rows(irf01)) 'construct a conditioning path for the response of P to FF
swmodel.localirfs(horizon=24,imp=4,cfact="3 3 1 3",cpath="condition",charts) 'p-values from Chi-squared

'Counterfactual analysis of the response of UN to FF with conditioning the response path of P to FF.
swmodel.localirfs(horizon=24,imp=4,cfact="2 3 1 3",cpath="condition",charts,pval=2) 'p-values from F-test


