﻿Imports System.Runtime.InteropServices
Imports System.Data.SqlClient

Public Class GenericSqlDb
    Implements EViewsEdx.IDatabase

    Private msCS As String
    Private msCatalog As String
    Private mconn As SqlConnection
    Private mcmd As SqlCommand
    Private mreader As SqlDataReader
    Private mGenSqlPrefs As GenericSqlPrefs
    Private msSchema As String

    Public Sub New(ByVal vsCS As String, _
                   ByRef rconn As SqlConnection, _
                   ByVal vsCatalog As String, _
                   ByRef rPrefs As GenericSqlPrefs)
        MyBase.New()

        msCS = vsCS
        msCatalog = vsCatalog
        mconn = rconn
        mGenSqlPrefs = rPrefs
        msSchema = ""
    End Sub

    Private Function BuildTableName(ByVal vsTableName As String) As String
        If msSchema > "" Then
            vsTableName = msSchema & "." & vsTableName
        End If
        Return vsTableName
    End Function

    Private Sub ExtractTableCol(ByVal vsObjectId As String, _
                                ByRef rsTableName As String, _
                                ByRef rsColumnName As String)
        Dim liPos As Integer = InStr(vsObjectId, GenericSqlDbMgr.TABLE_COLUMN_DELIM)
        If liPos > 0 Then
            rsTableName = Mid(vsObjectId, 1, liPos - 1)
            rsColumnName = Mid(vsObjectId, liPos + Len(GenericSqlDbMgr.TABLE_COLUMN_DELIM))
        Else
            rsTableName = ""
            rsColumnName = ""
        End If
    End Sub

    Private Sub CloseReader()
        If mreader IsNot Nothing Then
            Try
                mreader.Close()
            Catch ex As Exception
                'ignore
            End Try
        End If
    End Sub

    Public Sub Close() Implements EViewsEdx.IDatabase.Close
        Try
            CloseReader()
            mconn.Close()
        Catch ex As Exception
            'ignore
        End Try
    End Sub

    Public Sub CopyObject(ByVal srcObjectId As String, ByRef destObjectId As String, Optional ByVal overwrite As Boolean = False) Implements EViewsEdx.IDatabase.CopyObject
        Throw New NotImplementedException
    End Sub

    Public Sub DeleteObject(ByVal objectId As String) Implements EViewsEdx.IDatabase.DeleteObject
        Throw New NotImplementedException
    End Sub

    Public Function GetAttributes() As Object Implements EViewsEdx.IDatabase.GetAttributes
        Return Nothing
    End Function

    Public Sub ListObjectAttributes(ByRef attributeList As String, ByVal delim As String, ByRef scanForCustom As Boolean) Implements EViewsEdx.IDatabase.ListObjectAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub ReadObject(ByVal objectId As String, _
                          ByVal defaultFreq As String, _
                          ByRef attr As Object, _
                          ByRef vals As Object, _
                          ByRef ids As Object) _
            Implements EViewsEdx.IDatabase.ReadObject
        Dim lsTableName As String = ""
        Dim lsColumnName As String = ""
        ExtractTableCol(objectId, lsTableName, lsColumnName)

        Dim lconn As New SqlConnection(msCS)
        lconn.Open()
        Try
            Dim lsSQL As String = "select DATA_TYPE " & _
                                  "from INFORMATION_SCHEMA.COLUMNS " & _
                                  "where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & _
                                  " and COLUMN_NAME = " & Util.AsQuotedString(lsColumnName)
            Dim cmd As New SqlCommand(lsSQL, lconn)
            Dim lsTypeName As String = Util.myCStr(cmd.ExecuteScalar())

            If lsTypeName = "" Then
                Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_INVALID)
            End If
            Dim lsType As String = IIf(mGenSqlPrefs.TreatAsSeries, "series", "vector")
            If InStr(lsTypeName, "varchar", CompareMethod.Text) > 0 Then
                lsType = IIf(mGenSqlPrefs.TreatAsSeries, "alpha", "svector")
            End If

            'see if we can find a ID column...
            Dim lsIDColumn As String = ""
            'If mGenSqlPrefs.IDColumnName > "" Then
            '    If mGenSqlPrefs.ExactMatch Then
            '        lsSQL = "select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & " and COLUMN_NAME = " & Util.AsQuotedString(mGenSqlPrefs.IDColumnName)
            '    Else
            '        lsSQL = "select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & " and COLUMN_NAME like '%" & mGenSqlPrefs.IDColumnName & "%'"
            '    End If
            '    cmd.CommandText = lsSQL
            '    Dim da As New SqlDataAdapter(cmd)
            '    Dim dsCols As New DataSet
            '    da.Fill(dsCols)

            '    If dsCols.Tables(0).Rows.Count > 0 Then
            '        lsIDColumn = Trim(Util.myCStr(dsCols.Tables(0).Rows(0).Item("COLUMN_NAME")))
            '    End If
            'End If

            lsSQL = "select count(*) as RecCnt from " & BuildTableName(lsTableName)
            cmd.CommandText = lsSQL
            Dim liRowCnt As Integer = Util.myCInt(cmd.ExecuteScalar())

            attr = "type=" & lsType
            If mGenSqlPrefs.UseRowCount Then
                attr &= ", obs=" & liRowCnt.ToString
            ElseIf mGenSqlPrefs.FixedRowCount > 0 Then
                attr &= ", obs=" & mGenSqlPrefs.FixedRowCount.ToString
            End If
            If lsIDColumn = "" And mGenSqlPrefs.TreatAsSeries Then
                If mGenSqlPrefs.DefaultFrequency > "" Then
                    attr &= ", freq=" & mGenSqlPrefs.DefaultFrequency
                End If
                If mGenSqlPrefs.DefaultStart > "" Then
                    attr &= ", start=" & mGenSqlPrefs.DefaultStart
                End If
            End If

            Dim liArraySize As Integer = liRowCnt
            If Not mGenSqlPrefs.UseRowCount And mGenSqlPrefs.FixedRowCount > 0 Then
                liArraySize = mGenSqlPrefs.FixedRowCount
            End If

            ReDim vals(0 To liArraySize - 1)
            If lsIDColumn = "" Then
                lsSQL = "select top " & liArraySize.ToString & " " & _
                        lsColumnName & " from " & BuildTableName(lsTableName)
            Else
                ReDim ids(0 To liArraySize - 1)
                lsSQL = "select top " & liArraySize.ToString & " " & _
                        lsColumnName & ", " & lsIDColumn & " " & _
                        "from " & BuildTableName(lsTableName)
            End If
            cmd.CommandText = lsSQL
            Dim liIndex As Integer = -1
            Dim lreader As SqlDataReader = Nothing
            Try
                If liRowCnt > 0 Then
                    lreader = cmd.ExecuteReader()
                    While lreader.Read
                        liIndex += 1
                        vals(liIndex) = Util.myCStr(lreader(0))
                        'If lsIDColumn > "" Then
                        '    ids(liIndex) = lreader(1)
                        'End If
                    End While
                End If
                While liIndex < (liArraySize - 1)
                    liIndex += 1
                    vals(liIndex) = Nothing
                    'If lsIDColumn > "" Then
                    '    ids(liIndex) = Nothing
                    'End If
                End While
            Finally
                If lreader IsNot Nothing Then
                    lreader.Close()
                End If
            End Try
        Finally
            lconn.Close()
        End Try
    End Sub

    Public Sub ReadObjectAttributes(ByVal objectId As String, _
                                    ByVal defaultFreq As String, _
                                    ByRef attr As Object) _
            Implements EViewsEdx.IDatabase.ReadObjectAttributes
        Dim lsTableName As String = ""
        Dim lsColumnName As String = ""
        ExtractTableCol(objectId, lsTableName, lsColumnName)

        Dim lconn As New SqlConnection(msCS)
        lconn.Open()
        Try
            Dim lsSQL As String = "select DATA_TYPE " & _
                                  "from INFORMATION_SCHEMA.COLUMNS " & _
                                  "where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & _
                                  " and COLUMN_NAME = " & Util.AsQuotedString(lsColumnName)
            Dim cmd As New SqlCommand(lsSQL, lconn)
            Dim lsTypeName As String = Util.myCStr(cmd.ExecuteScalar())
            If lsTypeName = "" Then
                Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_INVALID)
            End If
            Dim lsType As String = IIf(mGenSqlPrefs.TreatAsSeries, "series", "vector")
            If InStr(lsTypeName, "varchar", CompareMethod.Text) > 0 Then
                lsType = IIf(mGenSqlPrefs.TreatAsSeries, "alpha", "svector")
            End If

            Dim lsIDColumn As String = ""
            'If mGenSqlPrefs.IDColumnName > "" Then
            '    If mGenSqlPrefs.ExactMatch Then
            '        lsSQL = "select * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & " and COLUMN_NAME = " & Util.AsQuotedString(mGenSqlPrefs.IDColumnName)
            '    Else
            '        lsSQL = "select top 1 * from INFORMATION_SCHEMA.COLUMNS where TABLE_NAME = " & Util.AsQuotedString(lsTableName) & " and COLUMN_NAME like '%" & mGenSqlPrefs.IDColumnName & "%'"
            '    End If
            '    cmd.CommandText = lsSQL
            '    Dim da As New SqlDataAdapter(cmd)
            '    Dim dsCols As New DataSet
            '    da.Fill(dsCols)

            '    If dsCols.Tables(0).Rows.Count > 0 Then
            '        lsIDColumn = Trim(Util.myCStr(dsCols.Tables(0).Rows(0).Item("COLUMN_NAME")))
            '    End If
            'End If

            attr = "name=" & objectId & ", type=" & lsType
            If mGenSqlPrefs.UseRowCount Then
                lsSQL = "select count(*) as RecCnt from " & BuildTableName(lsTableName)
                cmd.CommandText = lsSQL
                Dim liRowCnt As Integer = Util.myCInt(cmd.ExecuteScalar())
                attr &= ", obs=" & liRowCnt.ToString
            ElseIf mGenSqlPrefs.FixedRowCount > 0 Then
                attr &= ", obs=" & mGenSqlPrefs.FixedRowCount.ToString
            End If
            If lsIDColumn = "" And mGenSqlPrefs.TreatAsSeries Then
                If mGenSqlPrefs.DefaultFrequency > "" Then
                    attr &= ", freq=" & mGenSqlPrefs.DefaultFrequency
                End If
                If mGenSqlPrefs.DefaultStart > "" Then
                    attr &= ", start=" & mGenSqlPrefs.DefaultStart
                End If
            End If
        Finally
            lconn.Close()
        End Try
    End Sub

    Public Sub RenameObject(ByVal srcObjectId As String, ByVal destObjectId As String) Implements EViewsEdx.IDatabase.RenameObject
        Throw New NotImplementedException
    End Sub

    Public Sub SearchAbort() Implements EViewsEdx.IDatabase.SearchAbort
        CloseReader()
    End Sub

    Public Sub SearchByAttributes(ByVal searchExpression As String, _
                                  ByVal attrNames As String) _
            Implements EViewsEdx.IDatabase.SearchByAttributes
        Dim lsSQL As String

        'clean up 
        CloseReader()

        If mGenSqlPrefs.IncludeViews Then
            lsSQL = "select a.* from INFORMATION_SCHEMA.COLUMNS a " & _
                    "inner join INFORMATION_SCHEMA.TABLES b " & _
                    "on b.TABLE_CATALOG = a.TABLE_CATALOG " & _
                    "and b.TABLE_SCHEMA = a.TABLE_SCHEMA " & _
                    "and b.TABLE_NAME = a.TABLE_NAME " & _
                    "and b.TABLE_TYPE in ('BASE TABLE', 'VIEW') " & _
                    "order by a.TABLE_NAME, a.COLUMN_NAME"
        Else
            lsSQL = "select a.* from INFORMATION_SCHEMA.COLUMNS a " & _
                    "inner join INFORMATION_SCHEMA.TABLES b " & _
                    "on b.TABLE_CATALOG = a.TABLE_CATALOG " & _
                    "and b.TABLE_SCHEMA = a.TABLE_SCHEMA " & _
                    "and b.TABLE_NAME = a.TABLE_NAME " & _
                    "and b.TABLE_TYPE in ('BASE TABLE') " & _
                    "order by a.TABLE_NAME, a.COLUMN_NAME"
        End If

        'open a new reader object
        mcmd = New SqlCommand(lsSQL, mconn)
        mreader = mcmd.ExecuteReader()
    End Sub

    Public Function SearchByBrowser(ByVal browserArgs As Object, ByRef attrNames As String) As Object Implements EViewsEdx.IDatabase.SearchByBrowser
        'not supported
        Return Nothing
    End Function

    Public Function SearchNext(ByRef objectId As String, _
                               ByRef attr As Object) As Boolean _
            Implements EViewsEdx.IDatabase.SearchNext
        If mreader Is Nothing Then
            Return False
        End If

        'if we're at the end of the reader object, return false
        If Not mreader.Read Then
            mreader.Close()
            Return False
        End If

        msSchema = Util.myCStr(mreader("TABLE_SCHEMA"))
        objectId = Util.myCStr(mreader("TABLE_NAME")) & _
                   GenericSqlDbMgr.TABLE_COLUMN_DELIM & _
                   Util.myCStr(mreader("COLUMN_NAME"))

        ReadObjectAttributes(objectId, "", attr)

        Return True
    End Function

    Public Sub SetAttributes(ByVal attr As Object) Implements EViewsEdx.IDatabase.SetAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub WriteObject(ByRef objectId As String, ByVal attr As Object, ByVal vals As Object, ByVal ids As Object, ByVal overwriteMode As EViewsEdx.WriteType) Implements EViewsEdx.IDatabase.WriteObject
        Throw New NotImplementedException
    End Sub

    Public Sub BeginWrite(ByVal label As String) Implements EViewsEdx.IDatabase.BeginWrite

    End Sub

    Public Function DoCommand(ByVal commandId As String, ByVal args As Object) As Object Implements EViewsEdx.IDatabase.DoCommand
        Return Nothing
    End Function

    Public Sub EndWrite(ByVal reserved As Integer) Implements EViewsEdx.IDatabase.EndWrite

    End Sub

    Public Function GetCommandIds() As Object Implements EViewsEdx.IDatabase.GetCommandIds
        Return Nothing
    End Function

    Public Sub ReadObjects(ByVal objectIds As Object, ByVal destFreqInfo As Object, ByRef attr As Object, ByRef vals As Object, ByRef ids As Object) Implements EViewsEdx.IDatabase.ReadObjects

    End Sub

    Public Sub WriteObjects(ByRef errors As Object, ByRef objectIds As Object, ByVal attr As Object, ByVal vals As Object, ByVal ids As Object, ByVal overwriteMode As EViewsEdx.WriteType) Implements EViewsEdx.IDatabase.WriteObjects

    End Sub
End Class
