﻿Imports System.IO

Public Class Util
    Public Shared Sub LogMsg(ByVal vsMsg As String)
        Dim lsLogPath As String = My.Settings.LogDir & "\edxsamples_log.txt"
        Dim lsDate As String = FormatDateTime(Now(), DateFormat.GeneralDate)
        Dim ts As New StreamWriter(lsLogPath, True)
        ts.WriteLine(lsDate & vbTab & vsMsg)
        'ts.WriteLine(vsMsg)
        ts.Close()
    End Sub

    Public Shared Function myCInt(ByRef roValue As Object) As Integer
        Try
            If roValue Is DBNull.Value Then
                Return 0
            End If
            Return CInt(roValue)
        Catch ex As Exception
            Return 0
        End Try
    End Function

    Public Shared Function myCStr(ByRef roValue As Object) As String
        Try
            If roValue Is DBNull.Value Then
                Return ""
            End If
            Return CStr(roValue)
        Catch ex As Exception
            Return ""
        End Try
    End Function

    Public Shared Function myCBool(ByRef roValue As Object, Optional ByVal vbDefaultValue As Boolean = False) As Boolean
        Try
            If roValue Is DBNull.Value Then
                Return vbDefaultValue
            End If
            Return CBool(roValue)
        Catch ex As Exception
            Return vbDefaultValue
        End Try
    End Function


    Public Shared Function Flatten(ByRef roValue As Object) As String
        Dim lsRet As String = ""

        If IsArray(roValue) Then
            For i As Integer = LBound(roValue) To UBound(roValue)
                lsRet &= roValue(i)
                If i < UBound(roValue) Then
                    lsRet &= ", "
                End If
            Next
            Return lsRet
        End If

        Try
            Return roValue.ToString
        Catch ex As Exception
            lsRet = ex.Message
        End Try

        Return lsRet
    End Function

    Public Shared Sub CreateSubDirectory(ByVal vsPath As String)
        Dim di As New System.IO.DirectoryInfo(vsPath)
        If di.Exists Then
            Return
        End If

        'Dim diParent As System.IO.DirectoryInfo = di.Parent
        'If diParent IsNot Nothing Then
        '    CreateSubDirectory(diParent.FullName)
        'End If

        di.Create()
    End Sub

    Public Shared Function AsQuotedString(ByRef roObject As Object) As String
        Dim lsValue As String = myCStr(roObject)
        lsValue = "'" & Replace(lsValue, "'", "''") & "'"
        Return lsValue
    End Function

End Class
