﻿Public Class GenericSqlPreferences

    Private mGenSqlPrefs As GenericSqlPrefs

    Public Sub New(ByRef rPrefs As GenericSqlPrefs)
        ' This call is required by the Windows Form Designer.
        InitializeComponent()

        ' Add any initialization after the InitializeComponent() call.
        mGenSqlPrefs = rPrefs

        With mGenSqlPrefs
            cbxDisplay.Checked = mGenSqlPrefs.DisplayOnEachRead
            txtFreq.Text = mGenSqlPrefs.DefaultFrequency
            txtStart.Text = mGenSqlPrefs.DefaultStart
            If mGenSqlPrefs.UseRowCount Then
                rbUseRowCount.Checked = True
            Else
                rbAlwaysReturn.Checked = True
            End If
            txtFixedRowCount.Text = mGenSqlPrefs.FixedRowCount.ToString
            txtIDColumnName.Text = mGenSqlPrefs.IDColumnName
            cbxExactMatch.Checked = mGenSqlPrefs.ExactMatch
            cbxIncludeViews.Checked = mGenSqlPrefs.IncludeViews
            If mGenSqlPrefs.TreatAsSeries Then
                rbSeries.Checked = True
            Else
                rbVector.Checked = True
            End If
        End With
    End Sub

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        'confirm the entered values...
        If Trim(txtFreq.Text) = "" Then
            MsgBox("Default frequency is required.", MsgBoxStyle.Critical)
            Return
        End If

        If Trim(txtStart.Text) = "" Then
            MsgBox("Default start is required.", MsgBoxStyle.Critical)
            Return
        End If

        If rbAlwaysReturn.Checked Then
            If Util.myCInt(txtFixedRowCount.Text) <= 0 Then
                MsgBox("You must specify a positive row count to always return.", MsgBoxStyle.Critical)
                Return
            End If
        End If

        'save all the values...
        With mGenSqlPrefs
            .DisplayOnEachRead = cbxDisplay.Checked
            .DefaultFrequency = txtFreq.Text
            .DefaultStart = txtStart.Text
            .UseRowCount = rbUseRowCount.Checked
            .FixedRowCount = Util.myCInt(txtFixedRowCount.Text)
            .IDColumnName = txtIDColumnName.Text
            .ExactMatch = cbxExactMatch.Checked
            .IncludeViews = cbxIncludeViews.Checked
            .TreatAsSeries = rbSeries.Checked
        End With

        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Me.Close()
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub
End Class