﻿Imports System.Runtime.InteropServices
Imports System.Data.SqlClient

<ClassInterface(ClassInterfaceType.None), _
 ComVisible(True)> _
Public Class GenericSqlDbMgr
    Implements EViewsEdx.IDatabaseManager

    Private mGenSqlPrefs As New GenericSqlPrefs

    Public Const TABLE_COLUMN_DELIM As String = "."

    Public Sub AdjustSearchNamePattern(ByRef objectIdPattern As String) Implements EViewsEdx.IDatabaseManager.AdjustSearchNamePattern
        Throw New NotImplementedException
    End Sub

    Public Sub Close() Implements EViewsEdx.IDatabaseManager.Close
        'do nothing
    End Sub

    Public Function ConfigurePreferences(ByVal server As String, _
                                         ByVal username As String, _
                                         ByVal password As String, _
                                         ByRef prefs As String) As Boolean _
            Implements EViewsEdx.IDatabaseManager.ConfigurePreferences
        Dim frm As New GenericSqlPreferences(mGenSqlPrefs)
        Dim res As System.Windows.Forms.DialogResult = frm.ShowDialog()

        If res = Windows.Forms.DialogResult.Cancel Then
            Return False
        End If

        'save the preferences as a single string...
        With mGenSqlPrefs
            prefs = "DisplayOnEach=" & .DisplayOnEachRead.ToString & "|" & _
                    "DefaultFreq=" & .DefaultFrequency & "|" & _
                    "DefaultStart=" & .DefaultStart & "|" & _
                    "UseRowCount=" & .UseRowCount.ToString & "|" & _
                    "FixedRowCount=" & .FixedRowCount.ToString & "|" & _
                    "IDColumnName=" & .IDColumnName & "|" & _
                    "ExactMatch=" & .ExactMatch.ToString & "|" & _
                    "IncludeViews=" & .IncludeViews.ToString & "|" & _
                    "TreatAsSeries=" & .TreatAsSeries.ToString
        End With
        Return True
    End Function

    Public Function CopyDb(ByVal srcDatabaseId As String, ByVal destDatabaseId As String, ByVal server As String, ByVal username As String, ByVal password As String, ByVal overwrite As Boolean) As Boolean Implements EViewsEdx.IDatabaseManager.CopyDb
        Throw New NotImplementedException
    End Function

    Public Function DeleteDb(ByVal databaseId As String, ByVal server As String, ByVal username As String, ByVal password As String) As Boolean Implements EViewsEdx.IDatabaseManager.DeleteDb
        Throw New NotImplementedException
    End Function

    Public Function GetAttributes(ByVal clientInfo As String) As Object _
            Implements EViewsEdx.IDatabaseManager.GetAttributes
        Return "name=GenericSqlEDX, " & _
               "description=Generic Sql Server EDX Database, " & _
               "type=gsqledx, server, dbids, dbidlabel=Catalog, " & _
               "login=server|user|pass|dbid, search=all|attr, " & _
               "nocreate, readonly"
    End Function

    Public Function GetDatabaseIds(ByVal server As String, _
                                   ByVal username As String, _
                                   ByVal password As String) As Object _
            Implements EViewsEdx.IDatabaseManager.GetDatabaseIds

        'build the connection string
        Dim lsCS As String = "Data Source=" & server & ";"
        If username > "" Then
            lsCS &= lsCS & "User Id=" & username & ";"
        End If
        If password > "" Then
            lsCS &= lsCS & "Password=" & password & ";"
        End If

        'get the list of catalogs
        Dim lsReturn As String = ""
        Dim conn As SqlConnection = Nothing
        Try
            conn = New SqlConnection(lsCS)
            conn.Open()

            Dim d As New SqlCommand("exec sp_databases", conn)
            Dim r As SqlDataReader = d.ExecuteReader()
            Dim lsName As String
            While r.Read
                lsName = Util.myCStr(r(0))
                If lsName > "" Then
                    If lsReturn > "" Then
                        lsReturn &= vbCrLf
                    End If
                    'on each line, EViews is expecting: 
                    'code[tab]parentCode[tab]shortDesc[tab]longDesc
                    lsReturn &= lsName
                End If
            End While
            r.Close()
            conn.Close()
        Catch ex As Exception
            If InStr(ex.Message, "Login failed for user", _
                     CompareMethod.Text) > 0 Then
                Throw New COMException("", EViewsEdx.ErrorCode.SECURITY_LOGIN_INVALID)
            Else
                Throw New COMException(ex.Message)
            End If
        Finally
            If conn IsNot Nothing Then
                conn.Close()
            End If
        End Try

        Return lsReturn
    End Function

    Public Function OpenDb(ByVal databaseId As String, _
                           ByVal oc_mode As EViewsEdx.OpenCreateMode, _
                           ByVal rw_mode As EViewsEdx.ReadWriteMode, _
                           ByVal server As String, _
                           ByVal username As String, _
                           ByVal password As String) As EViewsEdx.IDatabase _
            Implements EViewsEdx.IDatabaseManager.OpenDb
        'build the connection string
        Dim lsCS As String = "Data Source=" & server & ";"
        Dim lsCatalog As String = ""
        Dim lsTable As String = ""
        Dim liPos As Integer = InStr(databaseId, TABLE_COLUMN_DELIM)
        If liPos > 0 Then
            lsCatalog = Mid(databaseId, 1, liPos - 1)
            lsTable = Mid(databaseId, liPos + Len(TABLE_COLUMN_DELIM))
        Else
            lsCatalog = databaseId
        End If
        If lsCatalog > "" Then
            lsCS &= lsCS & "Initial Catalog=" & lsCatalog & ";"
        End If
        If username > "" Then
            lsCS &= lsCS & "User Id=" & username & ";"
        End If
        If password > "" Then
            lsCS &= lsCS & "Password=" & password & ";"
        End If

        'make sure we can connect...
        Dim conn As SqlConnection = Nothing
        Try
            conn = New SqlConnection(lsCS)
            conn.Open()

        Catch ex As Exception
            If InStr(ex.Message, "Login failed for user", CompareMethod.Text) > 0 Then
                Throw New COMException("", EViewsEdx.ErrorCode.SECURITY_LOGIN_INVALID)
            Else
                Throw New COMException(ex.Message)
            End If
        End Try

        'connection made...
        Return New GenericSqlDb(lsCS, conn, lsTable, mGenSqlPrefs)
    End Function

    Public Function ProposeName(ByRef objectId As String, _
                                ByVal destFormat As EViewsEdx.DbFormat, _
                                ByVal destInfo As String) As Boolean _
            Implements EViewsEdx.IDatabaseManager.ProposeName
        Select Case destFormat
            Case EViewsEdx.DbFormat.EViewsDatabase
            Case EViewsEdx.DbFormat.EViewsWorkfile
                Dim liPos As Integer = InStr(objectId, _
                                             GenericSqlDbMgr.TABLE_COLUMN_DELIM)
                If liPos > 0 Then
                    objectId = Mid(objectId, liPos + 1)
                End If
        End Select
        'always display to the user the new name
        'in case it conflicts with somthing already
        'in the EViews database or workfile
        Return True
    End Function

    Public Function RenameDb(ByVal srcDatabaseId As String, ByVal destDatabaseId As String, ByVal server As String, ByVal username As String, ByVal password As String) As Boolean Implements EViewsEdx.IDatabaseManager.RenameDb
        Throw New NotImplementedException
    End Function

    Public Sub SetPreferences(ByVal prefs As String) _
            Implements EViewsEdx.IDatabaseManager.SetPreferences
        If Trim(Util.myCStr(prefs)) = "" Then
            Return
        End If

        Dim la() As String = Split(prefs, "|")
        Dim liPos As Integer
        Dim lsName As String
        Dim lsValue As String
        For Each item As String In la
            If item > "" Then
                liPos = InStr(item, "=")
                If liPos > 0 Then
                    lsName = Mid(item, 1, liPos - 1)
                    lsValue = Mid(item, liPos + 1)
                    With mGenSqlPrefs
                        Select Case LCase(lsName)
                            Case "displayoneach"
                                .DisplayOnEachRead = Util.myCBool(lsValue, False)

                            Case "defaultfreq"
                                .DefaultFrequency = Trim(lsValue)

                            Case "defaultstart"
                                .DefaultStart = Trim(lsValue)

                            Case "userowcount"
                                .UseRowCount = Util.myCBool(lsValue, True)

                            Case "fixedrowcount"
                                .FixedRowCount = Util.myCInt(lsValue)

                            Case "idcolumnname"
                                .IDColumnName = lsValue

                            Case "exactmatch"
                                .ExactMatch = Util.myCBool(lsValue, False)

                            Case "includeviews"
                                .IncludeViews = Util.myCBool(lsValue, True)

                            Case "treatasseries"
                                .TreatAsSeries = Util.myCBool(lsValue, True)
                        End Select
                    End With
                End If
            End If
        Next
    End Sub
End Class
