﻿'A simple dialog used for obtaining information required to create a new serise

Public Class NewSeriesDialog
    Public objectName As String
    Public objectType As String
    Public objectFrequency As String
    Public ObjectStartDate As Object

    Public Sub New()
        InitializeComponent()
    End Sub

    Private Sub NewSeriesDialog_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        'default to creating a numeric series
        NewType.SelectedItem = "Series"
    End Sub


    Private Sub OKButton_Click(sender As Object, e As EventArgs) Handles OK.Click
        'validate freq, start and end date
        Dim Frequency As EViewsEdx.Frequency = New EViewsEdx.Frequency
        Dim isIntegerDated As Boolean = False

        Dim invalidInput As Boolean = False
        If (Trim(NewName.Text).Length = 0) Then
            'name is missing
            MsgBox("Please provide a name.")
            NewName.Focus()
            invalidInput = True
        ElseIf (Trim(NewFrequency.Text).Length = 0) Then
            'frequency is missing
            MsgBox("Please provide a frequency.")
            NewFrequency.Focus()
            invalidInput = True
        ElseIf (Trim(NewStart.Text).Length = 0) Then
            'start date is missing
            MsgBox("Please provide a start date.")
            NewStart.Focus()
            invalidInput = True
        Else
            'validate frequency
            If (Not Frequency.Set(NewFrequency.Text)) Then
                MsgBox("Invalid frequency: " & NewFrequency.Text)
                NewFrequency.Focus()
                invalidInput = True
            Else
                'validate start date
                isIntegerDated = (Frequency.ToString(False) = "U")
                If (Not isIntegerDated) Then
                    'calendar dated series
                    Dim startDate As Date = Frequency.StringtoD(NewStart.Text)
                    If (startDate = "0100-01-01") Then
                        MsgBox("Invalid start date: " & NewStart.Text)
                        NewFrequency.Focus()
                        invalidInput = True
                    End If
                Else
                    'undated/integer dated series
                    If (Not IsNumeric(NewStart.Text)) Then
                        MsgBox("Invalid start date: " & NewStart.Text)
                        NewFrequency.Focus()
                        invalidInput = True
                    End If
                End If
            End If

        End If

        If (Not invalidInput) Then
            'create frequency with start date
            Frequency.Set(NewFrequency.Text & " " & NewStart.Text)

            objectName = StrConv(Trim(NewName.Text), VbStrConv.Lowercase)
            objectType = NewType.Text
            objectFrequency = Frequency.ToString(False)
            If (Not isIntegerDated) Then
                'calendar dated
                ObjectStartDate = Frequency.OtoD(0)
            Else
                'undated/integer dated
                ObjectStartDate = CInt(NewStart.Text)
            End If

            DialogResult = Windows.Forms.DialogResult.OK
            Close()
        End If
    End Sub

    Private Sub CancelButton_Click(sender As Object, e As EventArgs) Handles Cancel.Click
        DialogResult = Windows.Forms.DialogResult.Cancel
        Close()
    End Sub

End Class