﻿Imports System.Runtime.InteropServices

<ClassInterface(ClassInterfaceType.None), _
 ComVisible(True)> _
Public Class XmlDbMgr
    Implements EViewsEdx.IDatabaseManager

    Private mDbPref As New XmlPrefs

    'DbMgr is constructed when EDXADD is called within EViews (to register
    'this Database Extension) and every time EViews is launched after that
    Public Sub New()
        MyBase.New()
    End Sub

    Public Sub AdjustSearchNamePattern(ByRef objectIdPattern As String) Implements EViewsEdx.IDatabaseManager.AdjustSearchNamePattern
        Throw New NotImplementedException
    End Sub

    'Close is called when EViews is shutting down...
    Public Sub Close() Implements EViewsEdx.IDatabaseManager.Close

    End Sub

    'Called by EViews when the user selects the View->Preferences menu option in the Database window.
    'Allows the user to view and change any database specific preferences.  All preferences must be returned to EViews in the "prefs" string
    'and will be stored in the EViews32.ini file for the current user.  This method must return True to signal to EViews that "prefs" has been changed.
    Public Function ConfigurePreferences(ByVal server As String, _
                                         ByVal username As String, _
                                         ByVal password As String, _
                                         ByRef prefs As String) As Boolean _
            Implements EViewsEdx.IDatabaseManager.ConfigurePreferences

        Dim frm As New XmlPreferences
        frm.txtObjectExt.Text = LCase(mDbPref.ObjectFileExt)

        Dim result As System.Windows.Forms.DialogResult = frm.ShowDialog()
        If result = Windows.Forms.DialogResult.OK Then
            mDbPref.ObjectFileExt = LCase(frm.txtObjectExt.Text)
            prefs = "ObjectFileExt=" & mDbPref.ObjectFileExt
            Return True
        End If

        Return False
    End Function

    'Called by EViews when the user selects Proc->Copy the Database menu option in the Database window.
    'srcDatabaseId is the database that is being copied.  destDatabaseId is the new name.  This method is called with
    'overwrite initially set to False.  If the destDatabaseId already exists, this method should throw the FILE_FILENAME_IN_USE
    'error code which will signal to EViews to ask the user if they want to Overwrite.  If the user selects Yes, this method
    'is called again with overwrite set to True.
    Public Function CopyDb(ByVal srcDatabaseId As String, ByVal destDatabaseId As String, ByVal server As String, ByVal username As String, ByVal password As String, ByVal overwrite As Boolean) As Boolean Implements EViewsEdx.IDatabaseManager.CopyDb

        Dim di As New System.IO.DirectoryInfo(destDatabaseId)
        If System.IO.Directory.Exists(destDatabaseId) Then
            If Not overwrite Then
                Throw New COMException("", EViewsEdx.ErrorCode.FILE_FILENAME_IN_USE)
            Else
                System.IO.Directory.Delete(destDatabaseId, True)
            End If
        End If

        di.Create()

        'copy all files from the source to dest
        Dim files() As String = System.IO.Directory.GetFiles(srcDatabaseId)
        For Each temp As String In files
            Dim fi As New System.IO.FileInfo(temp)
            fi.CopyTo(destDatabaseId & "\" & fi.Name)
        Next

        'we've taken care of the copy operation so return true
        Return True
    End Function

    'Called by EViews when the user selects Proc->Delete the Database menu option in the Database window.
    'databaseId is the database that is being deleted.
    Public Function DeleteDb(ByVal databaseId As String, ByVal server As String, ByVal username As String, ByVal password As String) As Boolean Implements EViewsEdx.IDatabaseManager.DeleteDb
        If System.IO.Directory.Exists(databaseId) Then
            System.IO.Directory.Delete(databaseId, True)
        End If

        'we've taken care of the delete operation so return true
        Return True
    End Function

    'When EViews first launches, it calls this method to get specific details on this database
    'so it can be displayed properly on the Open Database dialog (and, if supported, the Create Database dialog)
    'These attributes also determine if the database is read/write or read only, what types of searches are supported
    Public Function GetAttributes(ByVal clientInfo As String) As Object _
            Implements EViewsEdx.IDatabaseManager.GetAttributes
        Dim lsAtts As String = "name=XmlEDX, description=Xml EDX Database, " & _
                               "type=xmledx, search=all|attr, searchattr=name, " & _
                               "attrtype=strarray, dbidlabel=Folder"
        Return lsAtts
    End Function

    'If the database specifies the DBIDS attribute (in GetAttributes),
    'this method is called by EViews when the user clicks the "Browse" button on the 
    'Database Specification (DBOPEN) dialog -- Note: this button is named "Browse Files" if
    'DBIDS is not supported.  
    'This function should return a tab delimited list (or a 2 dimensional array) of available 
    'databases in the following column order:
    '   database code (required) \t parent database code (can be blank) \t short description (can be blank) \t long description (can be blank).
    'The list is then displayed in a tree control that the user can navigate to 
    'select which database to work with.
    Public Function GetDatabaseIds(ByVal server As String, ByVal username As String, ByVal password As String) As Object Implements EViewsEdx.IDatabaseManager.GetDatabaseIds
        Return Nothing
    End Function

    'Called by EViews to open a new connection to the database.  
    'By default, when DBOPEN is called, EViews will always first attempt to open the database with FileOpen and FileReadWrite.  
    'If the database does not support read/write, it should throw a COM Exception with the error code FOREIGN_WRITE_ACCESS_UNSUPPORTED.  
    'EViews will then call OpenDb again with FileOpen and FileReadOnly instead and will not bother to call any of the other methods that
    'are used to write to the database.
    Public Function OpenDb(ByVal databaseId As String, _
                           ByVal oc_mode As EViewsEdx.OpenCreateMode, _
                           ByVal rw_mode As EViewsEdx.ReadWriteMode, _
                           ByVal server As String, _
                           ByVal username As String, _
                           ByVal password As String) As EViewsEdx.IDatabase _
            Implements EViewsEdx.IDatabaseManager.OpenDb
        Return New XmlDb(databaseId, oc_mode, rw_mode, mDbPref)
    End Function

    Public Function ProposeName(ByRef objectId As String, ByVal destFormat As EViewsEdx.DbFormat, ByVal destInfo As String) As Boolean Implements EViewsEdx.IDatabaseManager.ProposeName
        Return False
    End Function

    Public Function RenameDb(ByVal srcDatabaseId As String, ByVal destDatabaseId As String, _
                             ByVal server As String, ByVal username As String, ByVal password As String) As Boolean Implements EViewsEdx.IDatabaseManager.RenameDb
        Dim diSrc As New System.IO.DirectoryInfo(srcDatabaseId)

        Dim di As New System.IO.DirectoryInfo(destDatabaseId)
        If System.IO.Directory.Exists(destDatabaseId) Then
            Throw New COMException("", EViewsEdx.ErrorCode.FILE_FILENAME_IN_USE)
        End If

        diSrc.MoveTo(destDatabaseId)

        'we've taken care of the rename operation so return true
        Return True
    End Function

    Public Sub SetPreferences(ByVal prefs As String) _
            Implements EViewsEdx.IDatabaseManager.SetPreferences
        Dim atts() As String = Split(prefs, ",")
        Dim nm As String
        Dim val As String
        Dim pos As Integer
        For Each att As String In atts
            If att > "" Then
                pos = InStr(att, "=")
                If pos > 0 Then
                    nm = Mid(att, 1, pos - 1)
                    val = Mid(att, pos + 1)
                Else
                    nm = att
                    val = att
                End If

                Select Case LCase(nm)
                    Case "objectfileext"
                        mDbPref.ObjectFileExt = val
                End Select

            End If
        Next
    End Sub
End Class

