﻿'Manager class for EIA Bulk File databases
'
'A single instance of this manager class is constructed by EViews the first time an EIA Bulk File database is used.
'Only one manager class is constructed per session.
'

Imports System.Runtime.InteropServices

<ProgId(FileDatabaseManager.myProgId),
    ClassInterface(ClassInterfaceType.None), _
    ComVisible(True)> _
Public Class FileDatabaseManager
    Implements EViewsEdx.IDatabaseManager

    'data members of class
    Public Const myProgId As String = "EdxEia.FileDatabaseManager"

    'called during EViews shutdown - nothing to do for this manager
    Public Sub Close() Implements EViewsEdx.IDatabaseManager.Close

    End Sub

    'this function is called by EViews once after this class is created to retrieve important information
    'about how EViews should interact with databases in this format.
    '
    'note that EViews passes in a client information strring which can be used to check EViews version information.
    '
    Public Function GetAttributes(clientInfo As String) As Object Implements EViewsEdx.IDatabaseManager.GetAttributes
        'parse client info
        Dim appName As String = Nothing
        Dim appVersion As Double
        Dim buildDate As Date
        Dim opts As Hashtable = Nothing
        ServerDatabaseManager.ParseClientInfo(appName, appVersion, buildDate, opts, clientInfo)

        'check for version 8 of EViews
        If (appName <> "EViews" Or appVersion < 8) Then
            MsgBox("The EIA Database Extension requires version 8.1 of EViews.", MsgBoxStyle.Information)
            Throw New COMException("Unable to initialize the EIA Database Extension", EViewsEdx.ErrorCode.FOREIGN_INITIALISE_FAILED)
        End If

        'check for build date
        If (buildDate < "2014-09-15") Then
            MsgBox("The EIA Database Extension requires a newer build of EViews. Please use Help/EViews Update from your EViews menus to update to the latest build.", MsgBoxStyle.Information)
            Throw New COMException("Unable to initialize the EIA Database Extension", EViewsEdx.ErrorCode.FOREIGN_INITIALISE_FAILED)
        End If

        Return "name=EIA Bulk, " & _
            "description=EIA Bulk File, " & _
            "type=eiabulk, " & _
            "nocreate, " & _
            "readonly, " & _
            "ext = eia," & _
            "search=all|attr|browser, " & _
            "searchattr=name," & _
            "dotnet=35"
    End Function

    'create a new database object and return it to EViews
    Public Function OpenDb(databaseId As String, oc_mode As EViewsEdx.OpenCreateMode, rw_mode As EViewsEdx.ReadWriteMode, _
                            server As String, username As String, password As String) As EViewsEdx.IDatabase Implements EViewsEdx.IDatabaseManager.OpenDb
        Return New FileDatabase(databaseId)
    End Function

    Public Function ConfigurePreferences(server As String, username As String, password As String, ByRef prefs As String) As Boolean Implements EViewsEdx.IDatabaseManager.ConfigurePreferences
        Return False
    End Function

    Public Sub SetPreferences(prefs As String) Implements EViewsEdx.IDatabaseManager.SetPreferences

    End Sub

    Public Function GetDatabaseIds(server As String, username As String, password As String) As Object Implements EViewsEdx.IDatabaseManager.GetDatabaseIds
        Return Nothing
    End Function

    Public Function RenameDb(srcDatabaseId As String, destDatabaseId As String, server As String, username As String, password As String) As Boolean Implements EViewsEdx.IDatabaseManager.RenameDb
        Return False
    End Function

    Public Function CopyDb(srcDatabaseId As String, destDatabaseId As String, server As String, username As String, password As String, overwrite As Boolean) As Boolean Implements EViewsEdx.IDatabaseManager.CopyDb
        Return False
    End Function

    Public Function DeleteDb(databaseId As String, server As String, username As String, password As String) As Boolean Implements EViewsEdx.IDatabaseManager.DeleteDb
        Return False
    End Function

    'called by EViews when the name of an object returned by this database is illegal in the destination format
    '
    'this function provides the manager with an opportunity to suggest a modification to the name.
    '
    'for EIA databases, we trim off the trailing frequency if it matches the workfile frequency.
    'we also replace '-' characters with $ since the $ is unused by EIA but legal in EViews.
    '
    Public Function ProposeName(ByRef objectId As String, destFormat As EViewsEdx.DbFormat, destFreqInfo As String) As Boolean Implements EViewsEdx.IDatabaseManager.ProposeName
        If (destFormat = EViewsEdx.DbFormat.EViewsWorkfile Or destFormat = EViewsEdx.DbFormat.EViewsDatabase) Then
            'if fetching to the same frequency workfile, trim the frequency off the end of the name
            Dim destFields As String() = Split(destFreqInfo, " ")
            Dim destFreq As String = destFields(0)
            If (objectId.EndsWith("." & destFreq)) Then
                objectId = Left(objectId, Len(objectId) - Len(destFreq) - 1)
            End If
            'replace dot with underscore
            objectId = objectId.Replace("."c, "_"c)
            'replace minus sign with $
            objectId = objectId.Replace("-"c, "$"c)
            'don't prompt
            Return False
        End If
        Return False

    End Function

    Public Sub AdjustSearchNamePattern(ByRef objectIdPattern As String) Implements EViewsEdx.IDatabaseManager.AdjustSearchNamePattern

    End Sub

End Class
