﻿Imports System.Runtime.InteropServices

Public Enum FieldOrder
    Name = 0
    Type
    Freq
    Start
    Data
End Enum

Public Class CustomDb
    Implements EViewsEdx.IDatabase

    Private msDatabaseId As String
    Private miLineIndex As Integer
    Private miLineCount As Integer
    Private maLines() As String

    Public Sub New(ByVal databaseId As String)
        MyBase.New()

        msDatabaseId = databaseId

        'make sure the file exists and throw an error if it doesn't
        If Not System.IO.File.Exists(msDatabaseId) Then
            Throw New COMException(String.Empty, EViewsEdx.ErrorCode.FILE_FILENAME_INVALID)
        End If

        maLines = System.IO.File.ReadAllLines(msDatabaseId)
        miLineCount = UBound(maLines) - LBound(maLines) + 1
    End Sub

    Private Sub BuildAttributeString(ByVal vsLine As String, _
                                     ByRef attr As Object, _
                                     Optional ByRef vsName As String = "")
        Dim laObject() As String = Split(vsLine, "|")

        attr = ""

        'name
        vsName = laObject(FieldOrder.Name)

        'freq
        If laObject(FieldOrder.Freq) > "" Then
            attr &= "freq=" & laObject(FieldOrder.Freq)
        End If

        'type
        If laObject(FieldOrder.Type) > "" Then
            If CStr(attr).Length > 0 Then
                attr &= ","
            End If
            attr &= "type=" & laObject(FieldOrder.Type)
        End If

        'start
        If laObject(FieldOrder.Start) > "" Then
            If CStr(attr).Length > 0 Then
                attr &= ","
            End If
            attr &= "start=" & laObject(FieldOrder.Start)
        End If

        'obs
        If CStr(attr).Length > 0 Then
            attr &= ","
        End If
        If laObject(FieldOrder.Data) > "" Then
            attr &= "obs=" & Split(laObject(FieldOrder.Data), ",").Count.ToString
        Else
            attr &= "obs=0"
        End If
    End Sub

    Public Sub Close() Implements EViewsEdx.IDatabase.Close
        'do nothing
    End Sub

    Public Sub CopyObject(ByVal srcObjectId As String, _
                          ByRef destObjectId As String, _
                          Optional ByVal overwrite As Boolean = False) _
            Implements EViewsEdx.IDatabase.CopyObject
        Throw New NotImplementedException
    End Sub

    Public Sub DeleteObject(ByVal objectId As String) _
            Implements EViewsEdx.IDatabase.DeleteObject
        Throw New NotImplementedException
    End Sub

    Public Function GetAttributes() As Object _
            Implements EViewsEdx.IDatabase.GetAttributes
        Throw New NotImplementedException
    End Function

    Public Sub ListObjectAttributes(ByRef attributeList As String, ByVal delim As String, ByRef scanForCustom As Boolean) Implements EViewsEdx.IDatabase.ListObjectAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub ReadObject(ByVal objectId As String, _
                          ByVal destFreqInfo As String, _
                          ByRef attr As Object, _
                          ByRef vals As Object, _
                          ByRef ids As Object) _
            Implements EViewsEdx.IDatabase.ReadObject
        For i As Integer = LBound(maLines) To UBound(maLines)
            If maLines(i).Length > 0 Then
                Dim laObject() As String = Split(maLines(i), "|")
                If UCase(laObject(FieldOrder.Name)) = UCase(objectId) Then
                    'found it
                    BuildAttributeString(maLines(i), attr)
                    'get the vals...
                    vals = Split(laObject(FieldOrder.Data), ",")
                    Return
                End If
            End If
        Next
        'since the object doesn't exist in our database, we'll throw the proper exception
        Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_INVALID)
    End Sub

    Public Sub ReadObjectAttributes(ByVal objectId As String, _
                                    ByVal destFreqInfo As String, _
                                    ByRef attr As Object) _
            Implements EViewsEdx.IDatabase.ReadObjectAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub RenameObject(ByVal srcObjectId As String, _
                            ByVal destObjectId As String) _
            Implements EViewsEdx.IDatabase.RenameObject
        Throw New NotImplementedException
    End Sub

    Public Sub SearchAbort() Implements EViewsEdx.IDatabase.SearchAbort

    End Sub

    Public Sub SearchByAttributes(ByVal searchExpression As String, _
                                  ByVal attrNames As String) _
            Implements EViewsEdx.IDatabase.SearchByAttributes
        'just reset our text array index pointer...
        miLineIndex = 0
    End Sub

    Public Function SearchByBrowser(ByVal browserArgs As Object, _
                                    ByRef attrNames As String) As Object _
            Implements EViewsEdx.IDatabase.SearchByBrowser
        Throw New NotImplementedException
    End Function

    Public Function SearchNext(ByRef objectId As String, _
                               ByRef attr As Object) As Boolean _
            Implements EViewsEdx.IDatabase.SearchNext
        'check if we're already at the end of the text file...
        If miLineIndex >= miLineCount Then
            Return False
        End If

        'skip to the next non-blank line...
        Do While (maLines(miLineIndex).Length = 0)
            miLineIndex += 1
            If miLineIndex >= miLineCount Then
                'we've reached the end of the text file...
                Return False
            End If
        Loop

        'parse the text line for the object attributes
        'and set the object name
        BuildAttributeString(maLines(miLineIndex), attr, objectId)

        'increment the line pointer to the next line...
        miLineIndex += 1
        Return True
    End Function

    Public Sub SetAttributes(ByVal attr As Object) _
            Implements EViewsEdx.IDatabase.SetAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub WriteObject(ByRef objectId As String, _
                           ByVal attr As Object, _
                           ByVal vals As Object, _
                           ByVal ids As Object, _
                           ByVal overwriteMode As EViewsEdx.WriteType) _
            Implements EViewsEdx.IDatabase.WriteObject
        Throw New NotImplementedException
    End Sub

    Public Sub BeginWrite(ByVal label As String) Implements EViewsEdx.IDatabase.BeginWrite

    End Sub

    Public Function DoCommand(ByVal commandId As String, ByVal args As Object) As Object Implements EViewsEdx.IDatabase.DoCommand
        Return Nothing
    End Function

    Public Sub EndWrite(ByVal reserved As Integer) Implements EViewsEdx.IDatabase.EndWrite

    End Sub

    Public Function GetCommandIds() As Object Implements EViewsEdx.IDatabase.GetCommandIds
        Return Nothing
    End Function

    Public Sub ReadObjects(ByVal objectIds As Object, ByVal destFreqInfo As Object, ByRef attr As Object, ByRef vals As Object, ByRef ids As Object) Implements EViewsEdx.IDatabase.ReadObjects

    End Sub

    Public Sub WriteObjects(ByRef errors As Object, ByRef objectIds As Object, ByVal attr As Object, ByVal vals As Object, ByVal ids As Object, ByVal overwriteMode As EViewsEdx.WriteType) Implements EViewsEdx.IDatabase.WriteObjects

    End Sub
End Class
