﻿Imports System.Runtime.InteropServices

Public Class XmlDb
    Implements EViewsEdx.IDatabase

    Private msDatabaseId As String
    Private mOpenCreateMode As EViewsEdx.OpenCreateMode
    Private mReadWriteMode As EViewsEdx.ReadWriteMode

    Private mSearchExpression As String
    Private mDbPref As XmlPrefs
    Private mFiles() As String
    Private mUpper As Integer
    Private mIndex As Integer

    Public Sub New(ByVal databaseId As String, _
                   ByVal oc_mode As EViewsEdx.OpenCreateMode, _
                   ByVal rw_mode As EViewsEdx.ReadWriteMode, _
                   ByRef roDbPref As XmlPrefs)
        MyBase.New()

        msDatabaseId = databaseId
        mOpenCreateMode = oc_mode
        mReadWriteMode = rw_mode
        mDbPref = roDbPref
        mUpper = 0
        mIndex = 0

        Dim lbDirExists As Boolean = System.IO.Directory.Exists(msDatabaseId)

        Select Case oc_mode
            Case EViewsEdx.OpenCreateMode.FileOpen
                If Not lbDirExists Then
                    Throw New System.Runtime.InteropServices.COMException(String.Empty, _
                        EViewsEdx.ErrorCode.FILE_FILENAME_INVALID)
                End If

            Case EViewsEdx.OpenCreateMode.FileCreate
                If lbDirExists Then
                    Throw New System.Runtime.InteropServices.COMException(String.Empty, _
                        EViewsEdx.ErrorCode.FILE_FILENAME_IN_USE)
                Else
                    'create the new subdirectory...
                    Util.CreateSubDirectory(msDatabaseId)
                End If

            Case EViewsEdx.OpenCreateMode.FileOverwrite
                If lbDirExists Then
                    'delete the directory first...
                    System.IO.Directory.Delete(msDatabaseId, True)
                    lbDirExists = False
                End If
                'create the new subdirectory...
                Util.CreateSubDirectory(msDatabaseId)

            Case EViewsEdx.OpenCreateMode.FileOpenCreate
                'create if not already existing
                If Not lbDirExists Then
                    Util.CreateSubDirectory(msDatabaseId)
                End If
        End Select
    End Sub

    Public Sub Close() Implements EViewsEdx.IDatabase.Close

    End Sub

    Public Sub CopyObject(ByVal srcObjectId As String, _
                          ByRef destObjectId As String, _
                          Optional ByVal overwrite As Boolean = False) _
            Implements EViewsEdx.IDatabase.CopyObject

        Dim lsSrcFilePath As String = msDatabaseId & "\" & _
                                      LCase(srcObjectId) & "." & _
                                      mDbPref.ObjectFileExt
        Dim lsDestFilePath As String = msDatabaseId & "\" & _
                                       LCase(destObjectId) & "." & _
                                       mDbPref.ObjectFileExt
        If System.IO.File.Exists(lsDestFilePath) And Not overwrite Then
            Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_IN_USE)
        End If

        Dim fi As New System.IO.FileInfo(lsSrcFilePath)
        fi.CopyTo(lsDestFilePath)
    End Sub

    Public Sub DeleteObject(ByVal objectId As String) _
            Implements EViewsEdx.IDatabase.DeleteObject

        Dim lsFilePath As String = msDatabaseId & "\" & _
                                   LCase(objectId) & "." & _
                                   mDbPref.ObjectFileExt
        If System.IO.File.Exists(lsFilePath) Then
            System.IO.File.Delete(lsFilePath)
        End If
    End Sub

    Public Function GetAttributes() As Object Implements EViewsEdx.IDatabase.GetAttributes
        'only description is currently supported
        'this database description shows up under View->Database Statistics
        Dim fi As New System.IO.FileInfo(msDatabaseId)
        'just display the filename
        Return "description=" & fi.Name
    End Function

    Public Sub ListObjectAttributes(ByRef attributeList As String, ByVal delim As String, ByRef scanForCustom As Boolean) Implements EViewsEdx.IDatabase.ListObjectAttributes
        Throw New NotImplementedException
    End Sub

    Public Sub ReadObject(ByVal objectId As String, _
                          ByVal defaultFreq As String, _
                          ByRef attr As Object, _
                          ByRef vals As Object, _
                          ByRef ids As Object) _
            Implements EViewsEdx.IDatabase.ReadObject
        Dim lsFilePath As String = msDatabaseId & "\" & _
                                   LCase(objectId) & "." & _
                                   mDbPref.ObjectFileExt

        If Not System.IO.File.Exists(lsFilePath) Then
            Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_INVALID)
        End If

        Dim ds As New DataSet
        Dim dtAttributes As DataTable
        Dim dtMeta As DataTable
        Dim dtData As DataTable
        Dim liSecondDimSize As Integer = 0

        Try
            ds.ReadXml(lsFilePath)
            dtAttributes = ds.Tables("Attributes")
            dtMeta = ds.Tables("Meta")
            dtData = ds.Tables("Data")

            If dtAttributes.Rows.Count > 0 Then
                attr = GetAttributesAsObject(dtAttributes)
            End If

            If dtMeta.Rows.Count > 0 Then
                liSecondDimSize = Util.myCInt(dtMeta.Rows(0).Item("SecondDimSize"))
            End If

            If liSecondDimSize = 0 Then
                ReDim vals(0 To dtData.Rows.Count - 1)
            Else
                ReDim vals(0 To dtData.Rows.Count - 1, 0 To (liSecondDimSize - 1))
            End If

            If dtData.Columns.Contains("ids") Then
                ReDim ids(0 To dtData.Rows.Count - 1)
            End If

            Dim i As Integer = 0
            For Each dr As DataRow In dtData.Rows
                If liSecondDimSize = 0 Then
                    vals(i) = dr("value")
                Else
                    For y As Integer = 1 To liSecondDimSize
                        vals(i, y - 1) = dr("value" & y.ToString)
                    Next
                End If
                If dtData.Columns.Contains("ids") Then
                    ids(i) = dr("id")
                End If
                i += 1
            Next

        Catch ex As Exception
            Throw New COMException("Specified xml file was not in a valid dataset xml format.")
        End Try
    End Sub

    Public Sub ReadObjectAttributes(ByVal objectId As String, _
                                    ByVal defaultFreq As String, _
                                    ByRef attr As Object) _
            Implements EViewsEdx.IDatabase.ReadObjectAttributes
        Throw New NotImplementedException()
    End Sub

    Public Sub RenameObject(ByVal srcObjectId As String, _
                            ByVal destObjectId As String) _
            Implements EViewsEdx.IDatabase.RenameObject

        Dim lsSrcFilePath As String = msDatabaseId & "\" & _
                                      LCase(srcObjectId) & "." & _
                                      mDbPref.ObjectFileExt
        If Not System.IO.File.Exists(lsSrcFilePath) Then
            Throw New System.Runtime.InteropServices.COMException("", EViewsEdx.ErrorCode.RECORD_NAME_INVALID)
        End If

        Dim lsDestFilePath As String = msDatabaseId & "\" & _
                                       LCase(destObjectId) & "." & _
                                       mDbPref.ObjectFileExt
        If System.IO.File.Exists(lsDestFilePath) Then
            Throw New System.Runtime.InteropServices.COMException("", EViewsEdx.ErrorCode.RECORD_NAME_IN_USE)
        End If


        Dim fi As New System.IO.FileInfo(lsSrcFilePath)
        fi.MoveTo(lsDestFilePath)
    End Sub

    Public Sub SearchAbort() Implements EViewsEdx.IDatabase.SearchAbort

    End Sub

    Public Sub SearchByAttributes(ByVal searchExpression As String, _
                                  ByVal attrNames As String) _
            Implements EViewsEdx.IDatabase.SearchByAttributes

        'store the search expression
        mSearchExpression = searchExpression

        mFiles = System.IO.Directory.GetFiles( _
                    msDatabaseId, _
                    mSearchExpression & "." & mDbPref.ObjectFileExt)

        'reset any previous search pointer...
        mUpper = UBound(mFiles)
        mIndex = 0
    End Sub

    Public Function SearchByBrowser(ByVal browserArgs As Object, ByRef attrNames As String) As Object Implements EViewsEdx.IDatabase.SearchByBrowser
        Return Nothing
    End Function

    Private Function GetAttributesAsObject(ByRef rdtAttributes As DataTable) _
            As Object
        Dim liColCount As Integer = rdtAttributes.Columns.Count
        Dim loArray(0 To (liColCount - 1), 0 To 1) As String

        For i As Integer = 0 To (liColCount - 1)
            loArray(i, 0) = rdtAttributes.Columns(i).ColumnName
            loArray(i, 1) = rdtAttributes.Rows(0).Item(loArray(i, 0))
        Next

        Return loArray
    End Function

    Public Function SearchNext(ByRef objectId As String, _
                               ByRef attr As Object) As Boolean _
            Implements EViewsEdx.IDatabase.SearchNext

TryAgain:
        If mIndex > mUpper Then
            Return False
        End If

        Dim temp As String = mFiles(mIndex)
        mIndex += 1

        Dim fi As New System.IO.FileInfo(temp)
        temp = fi.Name
        Dim pos As Integer = InStrRev(temp, ".")
        If pos > 0 Then
            temp = Mid(temp, 1, pos - 1)
        End If

        objectId = temp

        'try to get the attributes...
        Dim liSecondDimSize As Integer
        Try
            Dim ds As New DataSet
            Dim dtAttributes As DataTable
            Dim dtMeta As DataTable
            Dim dtData As DataTable

            ds.ReadXml(fi.FullName)
            dtAttributes = ds.Tables("Attributes")
            dtMeta = ds.Tables("Meta")
            dtData = ds.Tables("Data")

            If dtAttributes Is Nothing Or dtMeta Is Nothing Or dtData Is Nothing Then
                GoTo TryAgain
            End If

            If dtAttributes.Rows.Count > 0 Then
                'attr = Util.myCStr(dtMeta.Rows(0).Item("Attributes"))
                attr = GetAttributesAsObject(dtAttributes)
            End If

            'verify that we have a meta second dim size value as well
            If dtMeta.Rows.Count > 0 Then
                liSecondDimSize = Util.myCInt(dtMeta.Rows(0).Item("SecondDimSize"))
            End If

            Return True

        Catch ex As Exception
            'we encountered a file that wasn't a valid dataset xml (or the schema was unexpected)
            'skip it and try the next one...
            GoTo TryAgain
        End Try
    End Function

    Public Sub SetAttributes(ByVal attr As Object) Implements EViewsEdx.IDatabase.SetAttributes

    End Sub

    Public Sub DetermineSize(ByRef roObj As Object, ByRef riFirst As Integer, ByRef riSecond As Integer)
        If roObj Is Nothing Then
            riFirst = 0
            riSecond = 0
            Return
        End If

        Try
            riFirst = UBound(roObj, 1) - LBound(roObj, 1) + 1
        Catch ex As Exception
            riFirst = 0
        End Try

        Try
            riSecond = UBound(roObj, 2) - LBound(roObj, 2) + 1
        Catch ex As Exception
            riSecond = 0
        End Try
    End Sub

    Public Sub WriteObject(ByRef objectId As String, _
                           ByVal attr As Object, _
                           ByVal vals As Object, _
                           ByVal ids As Object, _
                           ByVal overwriteMode As EViewsEdx.WriteType) _
            Implements EViewsEdx.IDatabase.WriteObject

        Dim lsFilePath As String = msDatabaseId & "\" & _
                                   LCase(objectId) & "." & _
                                   mDbPref.ObjectFileExt

        Select Case overwriteMode
            Case EViewsEdx.WriteType.WriteProtect
                'if the file already exists, don't overwrite it...
                If System.IO.File.Exists(lsFilePath) Then
                    Throw New COMException("", EViewsEdx.ErrorCode.RECORD_NAME_IN_USE)
                End If

            Case EViewsEdx.WriteType.WriteOverwrite
                If System.IO.File.Exists(lsFilePath) Then
                    System.IO.File.Delete(lsFilePath)
                End If
        End Select

        Dim ds As New DataSet
        Dim dt As New DataTable

        'save the attributes
        dt.TableName = "Attributes"
        For i As Integer = LBound(attr) To UBound(attr)
            dt.Columns.Add(attr(i, 0))
        Next

        Dim dr As DataRow = dt.NewRow
        For i As Integer = LBound(attr) To UBound(attr)
            dr(attr(i, 0)) = attr(i, 1)
        Next
        dt.Rows.Add(dr)
        ds.Tables.Add(dt)

        'save our meta data
        Dim liFirstDim As Integer
        Dim liSecondDim As Integer
        DetermineSize(vals, liFirstDim, liSecondDim)

        dt = New DataTable("Meta")
        dt.Columns.Add("SecondDimSize")
        dr = dt.NewRow
        dr("SecondDimSize") = liSecondDim
        dt.Rows.Add(dr)

        ds.Tables.Add(dt)

        dt = New DataTable("Data")
        If ids IsNot Nothing Then
            dt.Columns.Add("id")
        End If
        If liSecondDim > 0 Then
            For y As Integer = 1 To liSecondDim
                dt.Columns.Add("value" & y.ToString)
            Next
        Else
            dt.Columns.Add("value")
        End If

        Dim lowerbound As Integer = LBound(vals)
        Dim upperbound As Integer = UBound(vals)

        For i As Integer = lowerbound To upperbound
            dr = dt.NewRow
            If ids IsNot Nothing Then
                dr("id") = ids(i)
            End If
            If liSecondDim = 0 Then
                dr("value") = vals(i)
            Else
                For y As Integer = 1 To liSecondDim
                    dr("value" & y.ToString) = vals(i, y - 1)
                Next
            End If
            dt.Rows.Add(dr)
        Next
        ds.Tables.Add(dt)

        'now save this dataset as xml...
        ds.WriteXml(lsFilePath)
    End Sub

    Public Sub BeginWrite(ByVal label As String) Implements EViewsEdx.IDatabase.BeginWrite

    End Sub

    Public Function DoCommand(ByVal commandId As String, ByVal args As Object) As Object Implements EViewsEdx.IDatabase.DoCommand
        Return Nothing
    End Function

    Public Sub EndWrite(ByVal reserved As Integer) Implements EViewsEdx.IDatabase.EndWrite

    End Sub

    Public Function GetCommandIds() As Object Implements EViewsEdx.IDatabase.GetCommandIds
        Return Nothing
    End Function

    Public Sub ReadObjects(ByVal objectIds As Object, ByVal destFreqInfo As Object, ByRef attr As Object, ByRef vals As Object, ByRef ids As Object) Implements EViewsEdx.IDatabase.ReadObjects

    End Sub

    Public Sub WriteObjects(ByRef errors As Object, ByRef objectIds As Object, ByVal attr As Object, ByVal vals As Object, ByVal ids As Object, ByVal overwriteMode As EViewsEdx.WriteType) Implements EViewsEdx.IDatabase.WriteObjects

    End Sub
End Class
